/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.behaviour.dispenser;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.contraption.dispenser.DefaultMountedDispenseBehavior;
import com.simibubi.create.api.contraption.dispenser.MountedDispenseBehavior;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.item.ItemHelper;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class DropperMovementBehaviour
implements MovementBehaviour {
    @Override
    public void visitNewPosition(MovementContext context, class_2338 pos) {
        if (context.world.field_9236) {
            return;
        }
        MountedItemStorage storage = context.getItemStorage();
        if (storage == null) {
            return;
        }
        int slot = DropperMovementBehaviour.getSlot(storage, context.world.field_9229, context.contraption.getStorage().getAllItems());
        if (slot == -1) {
            DropperMovementBehaviour.failDispense(context, pos);
            return;
        }
        class_1799 stack = storage.getStackInSlot(slot).method_7972();
        MountedDispenseBehavior behavior = this.getDispenseBehavior(context, pos, stack);
        class_1799 remainder = behavior.dispense(stack, context, pos);
        storage.setStackInSlot(slot, remainder);
    }

    protected MountedDispenseBehavior getDispenseBehavior(MovementContext context, class_2338 pos, class_1799 stack) {
        return DefaultMountedDispenseBehavior.INSTANCE;
    }

    private static int getSlot(MountedItemStorage storage, class_5819 random, Storage<ItemVariant> contraptionInventory) {
        IntArrayList filledSlots = new IntArrayList();
        for (int i = 0; i < storage.getSlotCount(); ++i) {
            class_1799 stack = storage.getStackInSlot(i);
            if (stack.method_7960()) continue;
            if (stack.method_7947() == 1 && stack.method_7914() != 1) {
                if ((stack = DropperMovementBehaviour.tryTopOff(stack, contraptionInventory)) == null) continue;
                storage.setStackInSlot(i, stack);
            }
            filledSlots.add(i);
        }
        return switch (filledSlots.size()) {
            case 0 -> -1;
            case 1 -> filledSlots.getInt(0);
            default -> (Integer)class_156.method_32309((List)filledSlots, (class_5819)random);
        };
    }

    @Nullable
    private static class_1799 tryTopOff(class_1799 stack, Storage<ItemVariant> from) {
        Predicate<class_1799> test = otherStack -> class_1799.method_31577((class_1799)stack, (class_1799)otherStack);
        int needed = stack.method_7914() - stack.method_7947();
        class_1799 extracted = ItemHelper.extract(from, test, ItemHelper.ExtractionCountMode.UPTO, needed, false);
        return extracted.method_7960() ? null : stack.method_46651(stack.method_7947() + extracted.method_7947());
    }

    private static void failDispense(MovementContext ctx, class_2338 pos) {
        ctx.world.method_20290(1001, pos, 0);
    }
}

